qui {
noisily {
	/*************************************************/
	/*** Step 1.13. Data construction: summary	  ****/
	/*************************************************/
	}

/* 1.13.1. Summary of contributions/correlations of each dataset */
	
	preserve
	
	* Correctly identify non-reported country-years for battle deaths and financial crisis variable
	replace bdeaths = . if bdeaths == 0
	replace crisis = . if crisis == 0
	
	* Generate gdpcap variable
	generate gdpcap = baseline_gdpcap
	
	* Correctly identify state exit
	replace independence_years = . if cntry == "Yugoslavia" & year >= 1992
	replace independence_years = . if cntry == "Czechoslovakia" & year >= 1993
	
	* Correctly identify sources
	foreach variable in surface pop gdpcap educ health open dem bdeaths crisis {
		forval i=1/9 {
			replace source_`variable' = `i' if source_`variable' == 99`i' 	// 99 refers to interpolated/extrapolated data points, which are already indicated as such in the relevant indicator variables
			replace source_`variable' = `i' if source_`variable' == 90`i' 	// 99 refers to interpolated/extrapolated data points, which are already indicated as such in the relevant indicator variables
			}
		}
		
	
	* Total observations
	sum year if year >= $startyear & independence_years != .
	local totalyears = r(N)

	* Surface
	noi di "Surface"
	
		* LM
		sum year if year >= $startyear & independence_years != . & surface != . & source_surface == 1 & interpolated_surface == 0 & polynomialpredicted_surface == 0
		noi di "LM provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* WDI
		sum year if year >= $startyear & independence_years != . & surface != . & source_surface == 2 & interpolated_surface == 0 & polynomialpredicted_surface == 0
		noi di "WDI provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_surface_2
		noi di ""
		
		* Interpolated
		sum year if year >= $startyear & independence_years != . & surface != .  & interpolated_surface == 1 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are linearly interpolated"
		noi di ""
		
		* Extrapolated
		sum year if year >= $startyear & independence_years != . & surface != .  & extrapolated_surface == 1 & source_surface == 0
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are extrapolated (based on nearest LM data)"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & surface == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""

	* Population
	noi di ""
	noi di "Population"
	
		* COW
		sum year if year >= $startyear & independence_years != . & pop != . & source_pop == 1 & interpolated_pop == 0 & polynomialpredicted_pop == 0
		noi di "COW provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""

		* Madison2018
		sum year if year >= $startyear & independence_years != . & pop != . & source_pop == 2 & interpolated_pop == 0 & polynomialpredicted_pop == 0
		noi di "Madison2018 provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_pop_2
		noi di ""
		
		* WDI
		sum year if year >= $startyear & independence_years != . & pop != . & source_pop == 3 & interpolated_pop == 0 & polynomialpredicted_pop == 0
		noi di "WDI provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_pop_3
		noi di ""

		* Madison2010
		sum year if year >= $startyear & independence_years != . & pop != . & source_pop == 4 & interpolated_pop == 0 & polynomialpredicted_pop == 0
		noi di "Madison provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_pop_4
		noi di ""
		
		* PWT81
		sum year if year >= $startyear & independence_years != . & pop != . & source_pop == 5 & interpolated_pop == 0 & polynomialpredicted_pop == 0
		noi di "PWT8 provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_pop_5
		noi di ""
		
		* CLIO
		sum year if year >= $startyear & independence_years != . & pop != . & source_pop == 6 & interpolated_pop == 0 & polynomialpredicted_pop == 0
		noi di "CLIO provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_pop_6
		noi di ""
		
		* PWT56
		sum year if year >= $startyear & independence_years != . & pop != . & source_pop == 7 & interpolated_pop == 0 & polynomialpredicted_pop == 0
		noi di "PWT56 provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_pop_7
		noi di ""
				
		* Interpolated
		sum year if year >= $startyear & independence_years != . & pop != .  & interpolated_pop == 1 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are linearly interpolated"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & pop == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""
		
	* per capita GDP
	noi di ""
	noi di "per capita GDP"
	
		* Madison2017
		sum year if year >= $startyear & independence_years != . & baseline_gdpcap != . & source_gdpcap == 1 & interpolated_gdpcap == 0 & polynomialpredicted_gdpcap == 0
		noi di "Madison2017 provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* WDI
		sum year if year >= $startyear & independence_years != . & baseline_gdpcap != . & source_gdpcap == 2 & interpolated_gdpcap == 0 & polynomialpredicted_gdpcap == 0
		noi di "WDI provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_gdpcap_2
		noi di ""
		
		* WDI*
		sum year if year >= $startyear & independence_years != . & baseline_gdpcap != . & source_gdpcap == 3 & interpolated_gdpcap == 0 
		noi di "WDI* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_gdpcap_3
		noi di ""
		
		* CLIO*
		sum year if year >= $startyear & independence_years != . & baseline_gdpcap != . & source_gdpcap == 4 & interpolated_gdpcap == 0 //& polynomialpredicted_gdpcap == 1
		noi di "CLIO* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_gdpcap_4
		noi di ""
		
		* COW_NC*
		sum year if year >= $startyear & independence_years != . & baseline_gdpcap != . & source_gdpcap == 5 & interpolated_gdpcap == 0 
		noi di "COW_NC* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_gdpcap_5
		noi di ""
				
		* Interpolated
		sum year if year >= $startyear & independence_years != . & baseline_gdpcap != .  & interpolated_gdpcap == 1
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are linearly interpolated"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & baseline_gdpcap == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""
		
	* Education
	noi di ""
	noi di "Education"
				
		* CLIO
		sum year if year >= $startyear & independence_years != . & educ != . & source_educ == 1 & interpolated_educ == 0 
		noi di "CLIO provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* UNDP
		sum year if year >= $startyear & independence_years != . & educ != . & source_educ == 2 & interpolated_educ == 0 
		noi di "UNDP provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_educ_2
		noi di ""
		
		* barlee2017
		sum year if year >= $startyear & independence_years != . & educ != . & source_educ == 3 & interpolated_educ == 0 
		noi di "barlee2017 provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_educ_3
		noi di ""
		
		* barlee
		sum year if year >= $startyear & independence_years != . & educ != . & source_educ == 4 & interpolated_educ == 0 
		noi di "barlee provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_educ_4
		noi di ""
		
		* WDI*
		sum year if year >= $startyear & independence_years != . & educ != . & source_educ == 5 & interpolated_educ == 0 
		noi di "WDI* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_educ_5
		noi di ""
		
		* barlee*
		sum year if year >= $startyear & independence_years != . & educ != . & source_educ == 6 & interpolated_educ == 0 
		noi di "barlee* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_educ_6
		noi di ""
				
		* Interpolated
		sum year if year >= $startyear & independence_years != . & educ != .  & interpolated_educ == 1 | year >= $startyear & independence_years != . & educ != .  & source_educ == 0  
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are linearly interpolated"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & educ == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""
	
	* Health
	noi di ""
	noi di "Health"
	
		* WDI
		sum year if year >= $startyear & independence_years != . & health != . & source_health == 1 & interpolated_health == 0 | year >= $startyear & independence_years != . & health != . & source_health == 12 & interpolated_health == 0  | year >= $startyear & independence_years != . & health != . & source_health == 13 & interpolated_health == 0  | year >= $startyear & independence_years != . & health != . & source_health == 123 & interpolated_health == 0 
		noi di "WDI provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* CLIO
		sum year if year >= $startyear & independence_years != . & health != . & source_health == 1 & interpolated_health == 0 | year >= $startyear & independence_years != . & health != . & source_health == 12 & interpolated_health == 0  | year >= $startyear & independence_years != . & health != . & source_health == 23 & interpolated_health == 0  | year >= $startyear & independence_years != . & health != . & source_health == 123 & interpolated_health == 0 
		noi di "CLIO provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_health_2
		noi di ""
		
		* barlee
		sum year if year >= $startyear & independence_years != . & health != . & source_health == 1 & interpolated_health == 0 | year >= $startyear & independence_years != . & health != . & source_health == 13 & interpolated_health == 0  | year >= $startyear & independence_years != . & health != . & source_health == 23 & interpolated_health == 0  | year >= $startyear & independence_years != . & health != . & source_health == 123 & interpolated_health == 0 
		noi di "barlee provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_health_3
		noi di ""
				
		* Interpolated
		sum year if year >= $startyear & independence_years != . & health != .  & interpolated_health == 1 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are linearly interpolated"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & health == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""
	
	* Democracy
	noi di ""
	noi di "Democracy"

		* VH
		sum year if year >= $startyear & independence_years != . & dem != . & source_dem == 1 & interpolated_dem == 0 
		noi di "VH provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* CLIO
		sum year if year >= $startyear & independence_years != . & dem != . & source_dem == 2 & interpolated_dem == 0 
		noi di "CLIO provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_dem_2
		noi di ""
				
		* GM2*
		sum year if year >= $startyear & independence_years != . & dem != . & source_dem == 3 & interpolated_dem == 0 
		noi di "GM2* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_dem_3
		noi di ""
		
		* UDS*
		sum year if year >= $startyear & independence_years != . & dem != . & source_dem == 4 & interpolated_dem == 0 
		noi di "UDS* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_dem_4
		noi di ""
		
		* FHI*
		sum year if year >= $startyear & independence_years != . & dem != . & source_dem == 5 & interpolated_dem == 0 
		noi di "FHI* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_dem_5
		noi di ""
		
		* AEJ*
		sum year if year >= $startyear & independence_years != . & dem != . & source_dem == 6 & interpolated_dem == 0 
		noi di "AEJ* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_dem_6
		noi di ""
		
		* P2*
		sum year if year >= $startyear & independence_years != . & dem != . & source_dem == 7 & interpolated_dem == 0 
		noi di "P2* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_dem_7
		noi di ""
		
		* Interpolated
		sum year if year >= $startyear & independence_years != . & dem != .  & interpolated_dem == 1
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are linearly interpolated"
		noi di ""

		* Extrapolated
		sum year if year >= $startyear & independence_years != . & dem != .  & extrapolated_dem == 1 & source_dem == 0
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are extrapolated (based on nearest LM data)"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & dem == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""
	
	* Trade openness
	noi di ""
	noi di "Trade openness"
	
		* PWT81
		sum year if year >= $startyear & independence_years != . & open != . & source_open == 1 & interpolated_open == 0 
		noi di "PWT81 provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* WDI
		sum year if year >= $startyear & independence_years != . & open != . & source_open == 2 & interpolated_open == 0 
		noi di "WDI provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_open_2
		noi di ""
		
		* PWT56*
		sum year if year >= $startyear & independence_years != . & open != . & source_open == 3 & interpolated_open == 0 
		noi di "PWT56* provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_open_3
		noi di ""
		
		* COW_NC
		sum year if year >= $startyear & independence_years != . & open != . & source_open == 4 & interpolated_open == 0 
		noi di "COW_NC provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_open_4
		noi di ""
		
		* Interpolated
		sum year if year >= $startyear & independence_years != . & open != .  & interpolated_open == 1
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations are linearly interpolated"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & open == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""
	
	* Battle deaths
	noi di ""
	noi di "Battle deaths"
		
		* PRIO
		sum year if year >= $startyear & independence_years != . & bdeaths != . & source_bdeaths == 1 | year >= $startyear & independence_years != . & bdeaths != . & source_bdeaths == 12 
		noi di "PRIO provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* WDI
		sum year if year >= $startyear & independence_years != . & bdeaths != . & source_bdeaths == 2 | year >= $startyear & independence_years != . & bdeaths != . & source_bdeaths == 12 
		noi di "WDI provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations, the correlation with the baseline series equals", _continue correlation_bdeaths_1
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & bdeaths == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""
	
	
	* Macroeconomic uncertainty
	noi di ""
	noi di "Macroeconomic uncertainty"
	
		* RR
		sum year if year >= $startyear & independence_years != . & crisis != . & source_crisis == 1
		noi di "RR provides", _continue  round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations"
		noi di ""
		
		* Missing
		sum year if year >= $startyear & independence_years != . & crisis == . 
		noi di round(`r(N)'/`totalyears',.001)*100, _continue "% of the country-year observations remain missing"
		noi di ""	
		restore
				
/* 1.13.2. Summary table of data sources */

	* Table 2
		preserve
		
		* Correctly identify non-reported country-years for battle deaths and financial crisis variable
		replace bdeaths = . if bdeaths == 0
		replace crisis = . if crisis == 0
		
		* Generate gdpcap variable
		generate gdpcap = baseline_gdpcap
		
		* Correctly identify state exit
		replace independence_years = . if cntry == "Yugoslavia" & year >= 1992
		replace independence_years = . if cntry == "Czechoslovakia" & year >= 1993
	
		* Generate tabale components
		gen str variable = ""
		gen str primary_source = ""
		gen str primary_source_obs = ""
		gen str interpolated = ""
		gen str interpolated_obs = ""
		gen str imputed = ""
		gen str imputed_obs = ""
		gen str missing = ""
		gen str missing_obs = ""
		gen str primary_source_pre = ""
		gen str primary_source_pre_obs  = ""
		gen str interpolated_pre = ""
		gen str interpolated_pre_obs  = ""
		gen str missing_pre = ""
		gen str missing_pre_obs  = ""
		gen str imputed_pre = ""
		gen str imputed_pre_obs = ""

		* Compute total country-years and total pre-independence country-years
		sum year if year >= $startyear & independence_years != .
		local total_countryyears = `r(N)'
		sum year if year >= $startyear & independence_years != . & independence_years < 0
		local preindependence_countryyears = `r(N)'

		* Report data sources for all variables of interest
		local row = 0
		foreach variable in gdpcap surface pop educ health open dem bdeaths crisis {
			
			* Identify row
			local row = `row' + 1
						
			* Report variable
			if "`variable'" == "surface" {
				replace variable = "Surface area (km$^{2}$)" in `row'
				}
			if "`variable'" == "pop" {
				replace variable = "Population size " in `row'
				}
			if "`variable'" == "gdpcap" {
				replace variable = "GDP per capita" in `row'
				}
			if "`variable'" == "educ" {
				replace variable = "Years of schooling" in `row'
				}
			if "`variable'" == "health" {
				replace variable = "Life expectancy" in `row'
				}
			if "`variable'" == "open" {
				replace variable = "Trade openness" in `row'
				}
			if "`variable'" == "dem" {
				replace variable = "Democracy score" in `row'
				}
			if "`variable'" == "bdeaths" {
				replace variable = "Battle deaths per capita" in `row'
				}
			if "`variable'" == "crisis" {
				replace variable = "Macroeconomic uncertainty" in `row'
				}
				
				
				* All country-years
				
					* Primary sources
					// Note: extrapolating baseline series based on evolution in another existing source counted under 'primary source'
					sum year if year >= $startyear & independence_years != . & `variable' != . & interpolated_`variable' == 0 & extrapolated_`variable' == 0 & polynomialpredicted_`variable' == 0 | year >= $startyear & independence_years != . & `variable' != . & extrapolated_`variable' == 1 & source_`variable' != 0
					local percentage = string(round(((`r(N)'/`total_countryyears')*100),.1),"%9.0g")
					replace primary_source = "\textbf{`percentage'\%}" in `row'
					replace primary_source_obs = "\emph{[`r(N)']}" in `row'
					
					* Linearly interpolated / extended
					sum year if year >= $startyear & independence_years != . & `variable' != . & interpolated_`variable' == 1 | year >= $startyear & independence_years != . & `variable' != . & extrapolated_`variable' == 1 & source_`variable' == 0
					local percentage = string(round(((`r(N)'/`total_countryyears')*100),.1),"%9.0g")
					replace interpolated = "\textbf{`percentage'\%}" in `row'
					replace interpolated_obs = "\emph{[`r(N)']}" in `row'
					
					* Imputed
					sum year if year >= $startyear & independence_years != . & `variable' != . & polynomialpredicted_`variable' == 1
					local percentage = string(round(((`r(N)'/`total_countryyears')*100),.1),"%9.0g")
					replace imputed = "\textbf{`percentage'\%}" in `row'
					replace imputed_obs = "\emph{[`r(N)']}" in `row'
					
					* Missings
					sum year if year >= $startyear & independence_years != . & `variable' == .
					local percentage = string(round(((`r(N)'/`total_countryyears')*100),.1),"%9.0g")
					replace missing = "\textbf{`percentage'\%}" in `row'
					replace missing_obs = "\emph{[`r(N)']}" in `row'
					
				* Pre-independence country-years
								
					* Primary sources
					// Note: extrapolating baseline series based on evolution in another existing source counted under 'primary source'
					sum year if year >= $startyear & independence_years != . & `variable' != . & interpolated_`variable' == 0 & extrapolated_`variable' == 0 & polynomialpredicted_`variable' == 0 & independence_years < 0 | year >= $startyear & independence_years != . & `variable' != . & extrapolated_`variable' != 0 & source_`variable' != 0 & independence_years < 0
					local percentage = string(round(((`r(N)'/`preindependence_countryyears')*100),.1),"%9.0g")
					replace primary_source_pre = "\textbf{`percentage'\%}" in `row'
					replace primary_source_pre_obs = "\emph{[`r(N)']}" in `row'
					
					* Linearly interpolated / extended
					sum year if year >= $startyear & independence_years != . & `variable' != . & interpolated_`variable' == 1  & independence_years < 0 | year >= $startyear & independence_years != . & `variable' != . & extrapolated_`variable' == 1 & source_`variable' == 0 & independence_years < 0
					local percentage = string(round(((`r(N)'/`preindependence_countryyears')*100),.1),"%9.0g")
					replace interpolated_pre = "\textbf{`percentage'\%}" in `row'
					replace interpolated_pre_obs = "\emph{[`r(N)']}" in `row'
					
					* Imputed
					sum year if year >= $startyear & independence_years != . & `variable' != . & polynomialpredicted_`variable' == 1 & independence_years < 0
					local percentage = string(round(((`r(N)'/`preindependence_countryyears')*100),.1),"%9.0g")
					replace imputed_pre = "\textbf{`percentage'\%}" in `row'
					replace imputed_pre_obs = "\emph{[`r(N)']}" in `row'
					
					* Missings
					sum year if year >= $startyear & independence_years != . & `variable' == . & independence_years < 0
					local percentage = string(round(((`r(N)'/`preindependence_countryyears')*100),.1),"%9.0g")
					replace missing_pre = "\textbf{`percentage'\%}" in `row'
					replace missing_pre_obs = "\emph{[`r(N)']}" in `row'					
				}

		* Export information
		cd ..
		cd ".\5. TeX results"
		keep if variable != ""
		listtab variable primary_source primary_source_obs interpolated interpolated_obs imputed imputed_obs  missing missing_obs primary_source_pre primary_source_pre_obs interpolated_pre interpolated_pre_obs imputed_pre imputed_pre_obs missing_pre missing_pre_obs ///
		using "./table1.tex", replace ///
		rstyle(tabular) ///                              
		headlines("\begin{tabular}{lcccccccccccccccc}\toprule&\multicolumn{8}{c}{\textbf{All country-years}} & \multicolumn{8}{c}{\textbf{Pre-independence country-years}} \\\emph{Variable} & \multicolumn{2}{c}{\emph{Primary source}} & \multicolumn{2}{c}{\emph{Interpolated}} & \multicolumn{2}{c}{\emph{Proxied}} & \multicolumn{2}{c}{\emph{Missing}} & \multicolumn{2}{c}{\emph{Primary source}} & \multicolumn{2}{c}{\emph{Interpolated}} & \multicolumn{2}{c}{\emph{Proxied}} & \multicolumn{2}{c}{\emph{Missing}} \\ \cmidrule(lr){2-9} \cmidrule(lr){10-17}") ///
		footlines("\bottomrule \end{tabular}")
		restore
		
		* Reroute to directory containing dofiles		
		cd ..
		cd ".\1. Dofiles"
		}
